/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modifiers.ability.armor.DoubleJumpModifier;

public enum TinkerControlPacket implements IThreadsafePacket
{
    DOUBLE_JUMP,
    START_HELMET_INTERACT(TooltipKey.NORMAL),
    START_HELMET_INTERACT_SHIFT(TooltipKey.SHIFT),
    START_HELMET_INTERACT_CONTROL(TooltipKey.CONTROL),
    START_HELMET_INTERACT_ALT(TooltipKey.ALT),
    STOP_HELMET_INTERACT,
    START_LEGGINGS_INTERACT(TooltipKey.NORMAL),
    START_LEGGINGS_INTERACT_SHIFT(TooltipKey.SHIFT),
    START_LEGGINGS_INTERACT_CONTROL(TooltipKey.CONTROL),
    START_LEGGINGS_INTERACT_ALT(TooltipKey.ALT),
    STOP_LEGGINGS_INTERACT;

    private final TooltipKey modifier;

    private TinkerControlPacket() {
        this(TooltipKey.UNKNOWN);
    }

    public static TinkerControlPacket getStartHelmetInteract(TooltipKey key) {
        return switch (key) {
            case TooltipKey.SHIFT -> START_HELMET_INTERACT_SHIFT;
            case TooltipKey.CONTROL -> START_HELMET_INTERACT_CONTROL;
            case TooltipKey.ALT -> START_HELMET_INTERACT_ALT;
            default -> START_HELMET_INTERACT;
        };
    }

    public static TinkerControlPacket getStartLeggingsInteract(TooltipKey key) {
        return switch (key) {
            case TooltipKey.SHIFT -> START_LEGGINGS_INTERACT_SHIFT;
            case TooltipKey.CONTROL -> START_LEGGINGS_INTERACT_CONTROL;
            case TooltipKey.ALT -> START_LEGGINGS_INTERACT_ALT;
            default -> START_LEGGINGS_INTERACT;
        };
    }

    public static TinkerControlPacket read(class_2540 buffer) {
        return (TinkerControlPacket)buffer.method_10818(TinkerControlPacket.class);
    }

    @Override
    public void encode(class_2540 packetBuffer) {
        packetBuffer.method_10817((Enum)this);
    }

    @Override
    public void handleThreadsafe(ISimplePacket.Context context) {
        class_3222 player = context.getSender();
        if (player != null) {
            switch (this) {
                case DOUBLE_JUMP: {
                    DoubleJumpModifier.extraJump((class_1657)player);
                    break;
                }
                case START_HELMET_INTERACT: 
                case START_HELMET_INTERACT_SHIFT: 
                case START_HELMET_INTERACT_CONTROL: 
                case START_HELMET_INTERACT_ALT: {
                    InteractionHandler.startArmorInteract((class_1657)player, class_1304.field_6169, this.modifier);
                    break;
                }
                case STOP_HELMET_INTERACT: {
                    InteractionHandler.stopArmorInteract((class_1657)player, class_1304.field_6169);
                    break;
                }
                case START_LEGGINGS_INTERACT: 
                case START_LEGGINGS_INTERACT_SHIFT: 
                case START_LEGGINGS_INTERACT_CONTROL: 
                case START_LEGGINGS_INTERACT_ALT: {
                    InteractionHandler.startArmorInteract((class_1657)player, class_1304.field_6172, this.modifier);
                    break;
                }
                case STOP_LEGGINGS_INTERACT: {
                    InteractionHandler.stopArmorInteract((class_1657)player, class_1304.field_6172);
                }
            }
        }
    }

    private TinkerControlPacket(TooltipKey modifier) {
        this.modifier = modifier;
    }
}

